package devices;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

import centralSystem.ICentralSystem;
import centralSystem.counters.CountersProxy;
import centralSystem.counters.LongestQueueCounter;
import centralSystem.counters.OneServiceCounter;
import centralSystem.counters.PriorityServiceCounter;

public class CounterFrame extends JFrame {

	private static final long serialVersionUID = 1L;
	private static final String[] SERVICES = { "SERVIZI POSTALI",
			"SERVIZI FINANZIARI", "ALTRI SERVIZI" };
	private CountersProxy proxyCounter = new CountersProxy();
	private int counterIndex;
	private ICentralSystem centralSys;
	private JLabel label = new JLabel("Configurare la cassa per iniziare...");

	public CounterFrame(ICentralSystem centralSys) {
		super();
		super.setJMenuBar(this.buildMenu());
		this.centralSys = centralSys;
		this.centralSys.addCounter(proxyCounter);
		this.counterIndex = centralSys.countersNumber();
		super.setTitle("Poste Italiane - Cassa " + counterIndex);
		JPanel panel = new JPanel();
		panel = this.buildPanel();
		super.getContentPane().add(panel);
		super.setVisible(true);
		super.setSize(300, 100);
		super.setResizable(false);
		super.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	private JPanel buildPanel() {
		JPanel panel = new JPanel(new BorderLayout());
		JButton button = new JButton("Next >>");
		button.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
					try {
						int tmp = centralSys.nextService(counterIndex - 1);
						label.setText("Prossimo cliente: "
								+ centralSys.getNextClient(tmp) + " di "
								+ SERVICES[tmp]);
					} catch (Exception e1) {
						// TODO Auto-generated catch block
					}
			}
		});
		panel.add(button, BorderLayout.CENTER);
		panel.add(label, BorderLayout.SOUTH);
		return panel;
	}

	private JMenuBar buildMenu() {
		JMenuBar menubar = new JMenuBar();
		JMenu menu = new JMenu("Configurazione");

		JMenuItem item0 = new JMenuItem("Solo SERVIZI POSTALI");
		item0.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				proxyCounter.setCounter(new OneServiceCounter(centralSys, 0));
			}
		});
		JMenuItem item1 = new JMenuItem("Solo SERVIZI FINANZIARI");
		item1.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				proxyCounter.setCounter(new OneServiceCounter(centralSys, 1));
			}
		});
		JMenuItem item2 = new JMenuItem("Solo ALTRI SERVIZI");
		item2.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				proxyCounter.setCounter(new OneServiceCounter(centralSys, 2));
			}
		});
		JMenuItem item3 = new JMenuItem("Priorità SERVIZI POSTALI");
		item3.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				proxyCounter.setCounter(new PriorityServiceCounter(centralSys, 0));
			}
		});
		JMenuItem item4 = new JMenuItem("Priorità SERVIZI FINANZIARI");
		item4.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				proxyCounter.setCounter(new PriorityServiceCounter(centralSys, 1));
			}
		});
		JMenuItem item5 = new JMenuItem("Priorità ALTRI SERVIZI");
		item5.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				proxyCounter.setCounter(new PriorityServiceCounter(centralSys, 2));
			}
		});
		JMenuItem item6 = new JMenuItem("Fila più lunga");
		item6.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				proxyCounter.setCounter(new LongestQueueCounter(centralSys));
			}
		});
		menu.add(item0);
		menu.add(item1);
		menu.add(item2);
		menu.add(item3);
		menu.add(item4);
		menu.add(item5);
		menu.add(item6);
		menubar.add(menu);
		return menubar;
	}
}
